<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnUpdateV65 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if ( Schema::hasTable('movie_requests') ) {
            Schema::table('movie_requests', function (Blueprint $table) {
                if (!Schema::hasColumn('movie_requests','reply_message')){
                    $table->text('reply_message')->nullable();
                    }
            });
            }
            if ( Schema::hasTable('movies') ) {
                Schema::table('movies', function (Blueprint $table) {
                    if (!Schema::hasColumn('movies','free')){
                        $table->boolean('free')->default(0);
                        }
                });
                }
                if ( Schema::hasTable('tv_series') ) {
                    Schema::table('tv_series', function (Blueprint $table) {
                        if (!Schema::hasColumn('tv_series','free')){
                            $table->boolean('free')->default(0);
                            }
                    });
                    }
                    if ( Schema::hasTable('menus') ) {
                    Schema::table('menus', function (Blueprint $table) {
                        if (!Schema::hasColumn('menus','section_13')){
                            $table->boolean('section_13')->default(0);
                            }
                    });
                    }
                    if ( Schema::hasTable('configs') ) {
                        Schema::table('configs', function (Blueprint $table) {
                            if (!Schema::hasColumn('configs','cookie_msg')){
                                $table->text('cookie_msg')->nullable();
                                }
                        });
                        }
                        if ( Schema::hasTable('seos') ) {
                            Schema::table('seos', function (Blueprint $table) {
                                if (!Schema::hasColumn('seos','meta_home')){
                                    $table->text('meta_home')->nullable();
                                    }
                            });
                            }
                            if ( Schema::hasTable('player_settings') ) {
                                Schema::table('player_settings', function (Blueprint $table) {
                                    if (!Schema::hasColumn('player_settings','volume')){
                                        $table->text('volume')->nullable();
                                        }
                                });
                                }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
